# Catalio API - Bruno Collection

A [Bruno](https://www.usebruno.com/) collection for testing the Catalio JSON:API.

## Setup

1. Install Bruno from [usebruno.com](https://www.usebruno.com/)
2. Open Bruno and select **Open Collection**
3. Navigate to this directory (or extract the downloaded zip)

## Configuration

1. Open the **Environments** panel in Bruno
2. Select the `production` environment
3. Update the variables:
   - `client_id` — Your API credential client ID
   - `client_secret` — Your API credential client secret (click the lock icon to edit secrets)

## Getting Started

1. **Get Access Token** — Run the auth request first to obtain an access token
2. **List Requirements** — Verify the connection by listing requirements
3. **Create/Update/Delete** — Test CRUD operations on requirements

## Collection Structure

```text
bruno/
├── bruno.json              # Collection metadata
├── collection.bru          # Collection-level settings (auth, headers)
├── environments/
│   └── production.bru      # Production (catalio.ai)
├── auth/
│   └── Get Access Token.bru
└── requirements/
    ├── List Requirements.bru
    ├── Get Requirement.bru
    ├── Create Requirement.bru
    ├── Update Requirement.bru
    └── Delete Requirement.bru
```

## Environment Variables

| Variable        | Description                                  |
| --------------- | -------------------------------------------- |
| `base_url`      | Base URL of the Catalio instance             |
| `api_url`       | Full API URL including version               |
| `auth_url`      | Authentication endpoint URL                  |
| `client_id`     | Your API credential client ID                |
| `client_secret` | Your API credential client secret (secret)   |
| `audience`      | OAuth audience (`https://catalio.ai/api/v1`) |
| `access_token`  | Current access token (auto-set)              |
| `token_expiry`  | Token expiry timestamp (auto-set)            |

## JSON:API Format

All requests use the [JSON:API](https://jsonapi.org/) specification:

- Content-Type: `application/vnd.api+json`
- Accept: `application/vnd.api+json`

Example request body:

```json
{
  "data": {
    "type": "requirement",
    "attributes": {
      "title": "My Requirement",
      "description": "Details here"
    }
  }
}
```

## Troubleshooting

| Error            | Solution                                           |
| ---------------- | -------------------------------------------------- |
| 401 Unauthorized | Run "Get Access Token" first, or check credentials |
| 403 Forbidden    | Verify the resource belongs to your organization   |
| 404 Not Found    | Check the resource ID exists                       |

## Documentation

- [API Authentication](https://catalio.ai/docs/authentication)
- [JSON:API Overview](https://catalio.ai/docs/json-api-overview)
- [Swagger UI](https://catalio.ai/api/swaggerui)
